<?php echo $header; ?>
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?>
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/module.png" alt="" /> <?php echo $heading_title; ?></h1>
      <div class="buttons"><a onclick="$('#form').submit();" class="button"><?php echo $button_save; ?></a><a onclick="location = '<?php echo $cancel; ?>';" class="button"><?php echo $button_cancel; ?></a></div>
    </div>
    <div class="content">
      <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
        <table id="module" class="list">
          <thead>
            <tr>
              <td class="left"><?php echo $entry_limit; ?></td>
              <td class="left"><?php echo $entry_image; ?></td>
              <td class="left"><?php echo $entry_layout; ?></td>
              <td class="left"><?php echo $entry_position; ?></td>
              <td class="left"><?php echo $entry_add_related_products; ?></td>
              <td class="left"><?php echo $entry_only_show_in_blank_categories; ?></td>
              <td class="left"><?php echo $entry_categories; ?></td>
              <td class="left"><?php echo $entry_title; ?></td>
              <td class="left"><?php echo $entry_status; ?></td>              
              <td class="right"><?php echo $entry_sort_order; ?></td>
              <td></td>
            </tr>
          </thead>
          <?php $module_row = 0; ?>
          <?php foreach ($modules as $module) { ?>
          <tbody id="module-row<?php echo $module_row; ?>">
            <tr>
              <td class="left"><input type="text" name="products_category_module[<?php echo $module_row; ?>][limit]" value="<?php echo $module['limit']; ?>" size="1" /></td>
              <td class="left"><input type="text" name="products_category_module[<?php echo $module_row; ?>][image_width]" value="<?php echo $module['image_width']; ?>" size="2" />
                <input type="text" name="products_category_module[<?php echo $module_row; ?>][image_height]" value="<?php echo $module['image_height']; ?>" size="2" />
                <?php if (isset($error_image[$module_row])) { ?>
                <span class="error"><?php echo $error_image[$module_row]; ?></span>
                <?php } ?></td>
              <td class="left"><select name="products_category_module[<?php echo $module_row; ?>][layout_id]">
                  <?php foreach ($layouts as $layout) { ?>
                  <?php if ($layout['layout_id'] == $module['layout_id']) { ?>
                  <option value="<?php echo $layout['layout_id']; ?>" selected="selected"><?php echo $layout['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $layout['layout_id']; ?>"><?php echo $layout['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                </select></td>
              <td class="left"><select name="products_category_module[<?php echo $module_row; ?>][position]">
                  <?php if ($module['position'] == 'content_top') { ?>
                  <option value="content_top" selected="selected"><?php echo $text_content_top; ?></option>
                  <?php } else { ?>
                  <option value="content_top"><?php echo $text_content_top; ?></option>
                  <?php } ?>
                  <?php if ($module['position'] == 'content_bottom') { ?>
                  <option value="content_bottom" selected="selected"><?php echo $text_content_bottom; ?></option>
                  <?php } else { ?>
                  <option value="content_bottom"><?php echo $text_content_bottom; ?></option>
                  <?php } ?>
                  <?php if ($module['position'] == 'column_left') { ?>
                  <option value="column_left" selected="selected"><?php echo $text_column_left; ?></option>
                  <?php } else { ?>
                  <option value="column_left"><?php echo $text_column_left; ?></option>
                  <?php } ?>
                  <?php if ($module['position'] == 'column_right') { ?>
                  <option value="column_right" selected="selected"><?php echo $text_column_right; ?></option>
                  <?php } else { ?>
                  <option value="column_right"><?php echo $text_column_right; ?></option>
                  <?php } ?>
                </select></td>
              <td class="left"><select name="products_category_module[<?php echo $module_row; ?>][add_related_products]">
                  <?php if ($module['add_related_products']) { ?>
                  <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                  <option value="0"><?php echo $text_disabled; ?></option>
                  <?php } else { ?>
                  <option value="1"><?php echo $text_enabled; ?></option>

                  <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                  <?php } ?>
                </select></td>
              <td class="left"><select name="products_category_module[<?php echo $module_row; ?>][only_show_in_blank_categories]">
                  <?php if ($module['only_show_in_blank_categories']) { ?>
                  <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                  <option value="0"><?php echo $text_disabled; ?></option>
                  <?php } else { ?>
                  <option value="1"><?php echo $text_enabled; ?></option>
                  <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                  <?php } ?>
                </select></td> 

              <td class="left">
                <select name="products_category_module[<?php echo $module_row; ?>][category]">
                  <?php if ( !isset($module['category']) || $module['category']=='auto' ) { ?>
                      <option value="auto" selected="selected">Auto</option>
                  <?php } else { ?>
                      <option value="auto">Auto</option>
                  <?php } ?>
                  <?php foreach ($categories as $category) { ?>
                      <?php ($category['category_id'] == $module['category']) ? $selected = " selected=\"selected\"" : $selected="" ;?>
                      <option value="<?php echo $category['category_id']; ?>" <?php echo $selected;?>><?php echo $category['name'];?></option>
                  <?php } ?>
                </select>
              </td>

              <td class="left">
              		<?php foreach ($languages as $language) { ?>
              		<img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" />
              		<input type="text" name="products_category_module[<?php echo $module_row; ?>][title][<?php echo $language['language_id'];?>]" value="<?php echo isset($module['title'][$language['language_id']]) ? $module['title'][$language['language_id']] : ''; ?>" size="15" />
              		<br />
              		<?php } ?>
         	    </td>                               
              <td class="left"><select name="products_category_module[<?php echo $module_row; ?>][status]">
                  <?php if ($module['status']) { ?>
                  <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                  <option value="0"><?php echo $text_disabled; ?></option>
                  <?php } else { ?>
                  <option value="1"><?php echo $text_enabled; ?></option>
                  <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                  <?php } ?>
                </select></td>
              <td class="right"><input type="text" name="products_category_module[<?php echo $module_row; ?>][sort_order]" value="<?php echo $module['sort_order']; ?>" size="1" /></td>
              <td class="left"><a onclick="$('#module-row<?php echo $module_row; ?>').remove();" class="button"><?php echo $button_remove; ?></a></td>
            </tr>
          </tbody>
          <?php $module_row++; ?>
          <?php } ?>
          <tfoot>
            <tr>
              <td colspan="10"></td>
              <td class="left"><a onclick="addModule();" class="button"><?php echo $button_add_module; ?></a></td>
            </tr>
          </tfoot>
        </table>
      </form>
    </div>
  </div>
</div>
<script type="text/javascript"><!--
var module_row = <?php echo $module_row; ?>;

function addModule() {	
	html  = '<tbody id="module-row' + module_row + '">';
	html += '  <tr>';
	html += '    <td class="left"><input type="text" name="products_category_module[' + module_row + '][limit]" value="5" size="1" /></td>';
	html += '    <td class="left"><input type="text" name="products_category_module[' + module_row + '][image_width]" value="80" size="2" /> <input type="text" name="products_category_module[' + module_row + '][image_height]" value="80" size="2" /></td>';	
	html += '    <td class="left"><select name="products_category_module[' + module_row + '][layout_id]">';
	<?php foreach ($layouts as $layout) { ?>
	html += '      <option value="<?php echo $layout['layout_id']; ?>"><?php echo addslashes($layout['name']); ?></option>';
	<?php } ?>
	html += '    </select></td>';
	html += '    <td class="left"><select name="products_category_module[' + module_row + '][position]">';
	html += '      <option value="content_top"><?php echo $text_content_top; ?></option>';
	html += '      <option value="content_bottom"><?php echo $text_content_bottom; ?></option>';
	html += '      <option value="column_left"><?php echo $text_column_left; ?></option>';
	html += '      <option value="column_right"><?php echo $text_column_right; ?></option>';
	html += '    </select></td>';
	html += '    <td class="left"><select name="products_category_module[' + module_row + '][add_related_products]">';
	html += '      <option value="1"><?php echo $text_enabled; ?></option>';
	html += '      <option value="0" selected="selected"><?php echo $text_disabled; ?></option>';
	html += '    </select></td>';
	html += '    <td class="left"><select name="products_category_module[' + module_row + '][only_show_in_blank_categories]">';
	html += '      <option value="1"><?php echo $text_enabled; ?></option>';
	html += '      <option value="0" selected="selected"><?php echo $text_disabled; ?></option>';
	html += '    </select></td>';
	// html += '    <td class="left"><select name="products_category_module[' + module_row + '][show_add_to_cart]">';
	// html += '      <option value="1"><?php echo $text_enabled; ?></option>';
	// html += '      <option value="0" selected="selected"><?php echo $text_disabled; ?></option>';
	// html += '    </select></td>';
  html += '    <td class="left">';
  html += '      <select name="products_category_module[' + module_row + '][category]">';
  html += '          <option value="auto" selected="selected">Auto</option>';
                     <?php foreach ($categories as $category) { ?>
  html += '             <option value="<?php echo $category["category_id"];?>"><?php echo htmlentities($category["name"],ENT_QUOTES);?></option>';
                     <?php } ?>
  html += '      </select>';
  html += '    </td>';

	html += '    <td class="left">';
  html += '	    <?php foreach ($languages as $language) { ?>';
  html += '		    <img src="view/image/flags/<?php echo $language['image']; ?>" title="<?php echo $language['name']; ?>" />';
  html += '		    <input type="text" name="products_category_module[<?php echo $module_row; ?>][title][<?php echo $language['language_id'];?>]" value="<?php echo isset($module['title'][$language['language_id']]) ? $module['title'][$language['language_id']] : ''; ?>" size="15" />';
  html += '		    <br />';
  html += '	    <?php } ?>';
  html += '    </td>';
	html += '    <td class="left"><select name="products_category_module[' + module_row + '][status]">';
	html += '      <option value="1" selected="selected"><?php echo $text_enabled; ?></option>';
	html += '      <option value="0"><?php echo $text_disabled; ?></option>';
	html += '    </select></td>';
	html += '    <td class="right"><input type="text" name="products_category_module[' + module_row + '][sort_order]" value="" size="1" /></td>';
	html += '    <td class="left"><a onclick="$(\'#module-row' + module_row + '\').remove();" class="button"><?php echo $button_remove; ?></a></td>';
	html += '  </tr>';
	html += '</tbody>';
	
	$('#module tfoot').before(html);
	
	module_row++;
}
//--></script> 
<?php echo $footer; ?>
