<!DOCTYPE html>
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<head>
<meta charset="UTF-8" />
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<?php if ($description) { ?>
<meta name="description" content="<?php echo $description; ?>" />
<?php } ?>
<?php if ($keywords) { ?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<?php } ?>
<?php if ($icon) { ?>
<link href="<?php echo $icon; ?>" rel="icon" />
<?php } ?>
<?php foreach ($links as $link) { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/stylesheet/stylesheet.css" />
<link href='https://fonts.googleapis.com/css?family=Signika:400,600' rel='stylesheet' type='text/css'>



<?php if ($this->config->get('flexycart_colorpick') && $this->config->get('flexycart_colorpick') != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/colors/<?php echo $this->config->get('flexycart_colorpick'); ?>.css" />
<?php } ?>
<?php if (isset($this->request->get['colorpick']) && $this->request->get['colorpick'] != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/colors/<?php echo $this->request->get['colorpick']; ?>.css" />
<?php $this->session->data['colorpick'] = $this->request->get['colorpick']; ?>
<?php } elseif(isset($this->request->get['colorpick']) && $this->request->get['colorpick'] = 'default') { ?>
<?php $this->session->data['colorpick'] = ''; ?>
<?php } elseif(isset($this->session->data['colorpick']) && $this->session->data['colorpick'] != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/colors/<?php echo $this->session->data['colorpick']; ?>.css" />
<?php } ?>

<?php if ($this->config->get('flexycart_toolbar') && $this->config->get('flexycart_toolbar') != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/variations/toolbar/<?php echo $this->config->get('flexycart_toolbar'); ?>.css" />
<?php } ?>
<?php if (isset($this->request->get['toolbar']) && $this->request->get['toolbar'] != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/variations/toolbar/<?php echo $this->request->get['toolbar']; ?>.css" />
<?php $this->session->data['toolbar'] = $this->request->get['toolbar']; ?>
<?php } elseif(isset($this->request->get['toolbar']) && $this->request->get['toolbar'] = 'default') { ?>
<?php $this->session->data['toolbar'] = ''; ?>
<?php } elseif(isset($this->session->data['toolbar']) && $this->session->data['toolbar'] != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/variations/toolbar/<?php echo $this->session->data['toolbar']; ?>.css" />
<?php } ?>

<?php if ($this->config->get('flexycart_width') && $this->config->get('flexycart_width') != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/variations/width/<?php echo $this->config->get('flexycart_width'); ?>.css" />
<?php } ?>
<?php if (isset($this->request->get['width']) && $this->request->get['width'] != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/variations/width/<?php echo $this->request->get['width']; ?>.css" />
<?php $this->session->data['width'] = $this->request->get['width']; ?>
<?php } elseif(isset($this->request->get['width']) && $this->request->get['width'] = 'default') { ?>
<?php $this->session->data['width'] = ''; ?>
<?php } elseif(isset($this->session->data['width']) && $this->session->data['width'] != 'default') { ?>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/variations/width/<?php echo $this->session->data['width']; ?>.css" />
<?php } ?>


<?php foreach ($styles as $style) { ?>
<link rel="<?php echo $style['rel']; ?>" type="text/css" href="<?php echo $style['href']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>
<script type="text/javascript" src="catalog/view/javascript/jquery/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="catalog/view/javascript/jquery/ui/jquery-ui-1.8.16.custom.min.js"></script>
<link rel="stylesheet" type="text/css" href="catalog/view/javascript/jquery/ui/themes/ui-lightness/jquery-ui-1.8.16.custom.css" />
<script type="text/javascript" src="catalog/view/javascript/common.js"></script>
<script type="text/javascript" src="catalog/view/theme/flexycart/javascript/common.js"></script>
<?php foreach ($scripts as $script) { ?>
<script type="text/javascript" src="<?php echo $script; ?>"></script>
<?php } ?>
<!--[if IE 7]> 
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/stylesheet/ie7.css" />
<![endif]-->
<!--[if lt IE 7]>
<link rel="stylesheet" type="text/css" href="catalog/view/theme/flexycart/stylesheet/ie6.css" />
<script type="text/javascript" src="catalog/view/javascript/DD_belatedPNG_0.0.8a-min.js"></script>
<script type="text/javascript">
DD_belatedPNG.fix('#logo img');
</script>
<![endif]-->
<?php if ($stores) { ?>
<script type="text/javascript"><!--
$(document).ready(function() {
<?php foreach ($stores as $store) { ?>
$('body').prepend('<iframe src="<?php echo $store; ?>" style="display: none;"></iframe>');
<?php } ?>
});
//--></script>
<?php } ?>
<?php echo $google_analytics; ?>
</head>
<body>
<div id="toolbar">
  <?php echo $cart; ?>
  <div id="search">
    <div class="button-search"></div>
    <input type="text" name="search" placeholder="<?php echo $text_search; ?>" value="<?php echo $search; ?>" />
  </div>
  <div class="links"><a href="<?php echo $home; ?>"><?php echo $text_home; ?></a><a href="<?php echo $wishlist; ?>" id="wishlist-total"><?php echo $text_wishlist; ?></a><a href="<?php echo $account; ?>"><?php echo $text_account; ?></a><a href="<?php echo $shopping_cart; ?>"><?php echo $text_shopping_cart; ?></a><a href="<?php echo $checkout; ?>"><?php echo $text_checkout; ?></a></div>
  <?php echo $language; ?>
  <?php echo $currency; ?>
  </div>
<div id="container">
<div id="header">
  <?php if ($logo) { ?>
  <div id="logo"><a href="<?php echo $home; ?>"><img src="<?php echo $logo; ?>" title="<?php echo $name; ?>" alt="<?php echo $name; ?>" /></a></div>
  <?php } ?>
  <div id="welcome">
    <?php if (!$logged) { ?>
    <?php echo $text_welcome; ?>
    <?php } else { ?>
    <?php echo $text_logged; ?>
    <?php } ?>
  </div>
</div>
<?php if ($categories) { ?>
<div id="menu">
  <ul>
    <?php foreach ($categories as $category) { ?>
    <li><a href="<?php echo $category['href']; ?>"><?php echo $category['name']; ?></a>
      <?php if ($category['children']) { ?>
      <div>
        <?php for ($i = 0; $i < count($category['children']);) { ?>
        <ul>
          <?php $j = $i + ceil(count($category['children']) / $category['column']); ?>
          <?php for (; $i < $j; $i++) { ?>
          <?php if (isset($category['children'][$i])) { ?>
          <li><a href="<?php echo $category['children'][$i]['href']; ?>"><?php echo $category['children'][$i]['name']; ?></a></li>
          <?php } ?>
          <?php } ?>
        </ul>
        <?php } ?>
      </div>
      <?php } ?>
    </li>
    <?php } ?>
  </ul>
</div>
<?php } ?>
<div id="notification"></div>
