<?php
class ControllerModuleflexycart extends Controller {
	private $error = array(); 
	 
	public function index() {   
		$this->language->load('module/flexycart');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('flexycart', $this->request->post);		
			
			$this->session->data['success'] = $this->language->get('text_success');
						
			$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');
		$this->data['entry_colorpick'] = $this->language->get('entry_colorpick');
		$this->data['entry_toolbar'] = $this->language->get('entry_toolbar');
		$this->data['entry_width'] = $this->language->get('entry_width');
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_remove'] = $this->language->get('button_remove');
		

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/flexycart', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/flexycart', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['token'] = $this->session->data['token'];
		
		if (isset($this->request->post['flexycart_colorpick'])) {
			$this->data['flexycart_colorpick'] = $this->request->post['flexycart_colorpick'];
		} elseif ($this->config->get('flexycart_colorpick')) { 
			$this->data['flexycart_colorpick'] = $this->config->get('flexycart_colorpick');
		} else {
		    $this->data['flexycart_colorpick'] = '';
		}
		if (isset($this->request->post['flexycart_toolbar'])) {
			$this->data['flexycart_toolbar'] = $this->request->post['flexycart_toolbar'];
		} elseif ($this->config->get('flexycart_toolbar')) { 
			$this->data['flexycart_toolbar'] = $this->config->get('flexycart_toolbar');
		} else {
		    $this->data['flexycart_toolbar'] = '';
		}
		if (isset($this->request->post['flexycart_width'])) {
			$this->data['flexycart_width'] = $this->request->post['flexycart_width'];
		} elseif ($this->config->get('flexycart_width')) { 
			$this->data['flexycart_width'] = $this->config->get('flexycart_width');
		} else {
		    $this->data['flexycart_width'] = '';
		}
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();

		$this->template = 'module/flexycart.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/flexycart')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>